/* Copyright (c) 2005-2008 Di-an Jan.  All rights reserved.  */


import java.awt.Font;

import javax.swing.BoxLayout;			// 1.2

import javax.swing.JComponent;			// 1.2
import javax.swing.JLabel;			// 1.2
import javax.swing.Box;				// 1.2



final class Term extends Box
{
    static Font rm_font = new Font("Serif", Font.PLAIN,  12);
    static Font it_font = new Font("Serif", Font.ITALIC, 12);

    static JLabel rm_text(String s)
    {
	JLabel label = new JLabel(s);
	label.setFont(rm_font);
	return label;
    }

    static JLabel it_text(String s)
    {
	JLabel label = new JLabel(s);
	label.setFont(it_font);
	return label;
    }

    int		n;
    int		num;
    int		den;
    double	coef;

    Term(int n, int num, int den)
    {
	super(BoxLayout.LINE_AXIS);

	this.n = n;
	this.num = num;
	this.den = den;
	this.coef = (double) num / den;

	String s;
	if (num >= 0)
	    s = "  + ";
	else
	{
	    s = "  \u2212 ";
	    num = -num;
	}	

	if (n == 0)
	{
	    if (num % 2 == 0)
		num = num / 2;
	    else
		den = den * 2;
	    if (num == 0)
		den = 2;
	}

	if (den == 1 && n != 0)
	{
	    if (num != 1)
		s += " " + num;
	}
	else
	{
	    add(rm_text(s + " "));
	    add(new FractionElement(rm_text(Integer.toString(num)),
				    rm_text(Integer.toString(den))));
	    s = "";
	}

	if (n != 0)
	{
	    if (n > 0)
		s += " sin ";
	    else
	    {
		s += " cos ";
		n = -n;
	    } 	
	    add(rm_text(s));

	    JComponent t;
	    if (n == 1)
		t = it_text("\u03C0x");
	    else
	    {
		t = new Box(BoxLayout.LINE_AXIS);
		t.add(rm_text(Integer.toString(n)));
		t.add(it_text("\u03C0x"));
	    }
	    add(new FractionElement(t, it_text("L")));
	}
    }

    Term(int n, double coef)
    {
	super(BoxLayout.LINE_AXIS);

	this.n = n;
	this.num = 0;
	this.den = 0;
	this.coef = coef;

	String s = (coef >= 0) ? ("  +  " + coef) : ("  \u2212  " + (-coef));
	if (n == 0)
	    add(rm_text(s + " / 2"));
	else
	{
	    if (n > 0)
		s += " sin ";
	    else
		s += " cos ";
	    if (n > 1)
		s += n;
	    else if (n < -1)
		s += -n;
	    add(rm_text(s));
	    add(it_text("\u03C0x / L"));
	}
    }

    static Term cos(int n, int num, int den)	{ return new Term(-n, num, den); }
    static Term sin(int n, int num, int den)	{ return new Term(+n, num, den); }
    static Term cos(int n, double coef)		{ return new Term(-n, coef);     }
    static Term sin(int n, double coef)		{ return new Term(+n, coef);     }

    boolean isRational()
    {
	return den != 0;
    }

    boolean isSin()
    {
	return n > 0;
    }

    double eval(double x, double L)
    {
	if (n == 0)
	    return coef / 2;
	else if (n < 0)
	    return coef * Math.cos(n * Math.PI * x / L);
	else // if (n > 0)
	    return coef * Math.sin(n * Math.PI * x / L);
    }
} // final class Term

