/* Copyright (c) 2005-2008 Di-an Jan.  All rights reserved.  */


public final class WrapLayout implements java.awt.LayoutManager {


public void layoutContainer(java.awt.Container parent)
{
    java.awt.Insets insets = parent.getInsets();
    int width = parent.getWidth() - insets.left - insets.right;
    int row_height = 0;
    int x = insets.left;
    int y = insets.top;

    for (int n = 0; n < parent.getComponentCount(); n++)
    {
	java.awt.Component comp = parent.getComponent(n);
	if (comp == null || ! comp.isVisible())
	    continue;

	java.awt.Dimension dim = comp.getPreferredSize();

	if (x + dim.width > width)
	{
	    x = 0;
	    y += row_height;
	    row_height = 0;
	}
	comp.setBounds(x, y, dim.width, dim.height);

	if (x + dim.width <= width)
	    x += dim.width;

	if (dim.height > row_height)
	    row_height = dim.height;
    }
}


public java.awt.Dimension minimumLayoutSize(java.awt.Container parent)
{
    return parent.getSize();
}


public java.awt.Dimension preferredLayoutSize(java.awt.Container parent)
{
    return parent.getSize();
}


public void addLayoutComponent(java.lang.String name, java.awt.Component comp)
{
    /* No need to track components. */
}


public void removeLayoutComponent(java.awt.Component comp)
{
    /* No need to track components. */
}


} // public final class WrapLayout

